<?php
// app/Http/Requests/Api/Employee/FilterPaymentsRequest.php
namespace App\Http\Requests\Api\Employee;

use Illuminate\Foundation\Http\FormRequest;

class FilterPaymentsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'status' => 'nullable|in:pending,waiting_confirmation,confirmed,failed,refunded',
            'payment_method_id' => 'nullable|integer|exists:payment_methods,id',
            'date_from' => 'nullable|date',
            'date_to' => 'nullable|date|after_or_equal:date_from',
            'search' => 'nullable|string|max:100',
            'per_page' => 'nullable|integer|min:1|max:100',
        ];
    }
}