<?php
// app/Http/Requests/Api/Employee/FilterOrdersRequest.php
namespace App\Http\Requests\Api\Employee;

use Illuminate\Foundation\Http\FormRequest;

class FilterOrdersRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'status' => 'nullable|in:pending,confirmed,preparing,ready,completed,cancelled',
            'order_type' => 'nullable|in:dine_in,takeaway,delivery',
            'date_from' => 'nullable|date',
            'date_to' => 'nullable|date|after_or_equal:date_from',
            'search' => 'nullable|string|max:100',
            'per_page' => 'nullable|integer|min:1|max:100',
        ];
    }

    public function messages(): array
    {
        return [
            'date_to.after_or_equal' => 'Tanggal akhir harus setelah atau sama dengan tanggal awal',
        ];
    }
}