<?php
namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class PromoCheckRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'code' => 'required|string|exists:promos,code',
            'total_amount' => 'required|numeric|min:0',
        ];
    }

    public function messages(): array
    {
        return [
            'code.required' => 'Kode promo diperlukan',
            'code.exists' => 'Kode promo tidak valid',
            'total_amount.required' => 'Total amount diperlukan',
            'total_amount.min' => 'Total amount minimal 0',
        ];
    }
}