<?php
// app/Http/Requests/Api/Customer/PaymentUploadRequest.php
namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class PaymentUploadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'proof_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120', // 5MB max
            'payment_date' => 'required|date|before_or_equal:now',
            'reference_number' => 'nullable|string|max:100',
            'notes' => 'nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'proof_image.required' => 'Bukti pembayaran wajib diupload',
            'proof_image.image' => 'File harus berupa gambar',
            'proof_image.mimes' => 'Format gambar harus jpeg, png, jpg, atau gif',
            'proof_image.max' => 'Ukuran gambar maksimal 5MB',
            'payment_date.required' => 'Tanggal pembayaran wajib diisi',
            'payment_date.before_or_equal' => 'Tanggal pembayaran tidak boleh lebih dari hari ini',
        ];
    }
}