<?php

namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class OrderRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'order_type' => 'required|in:dine_in,takeaway,delivery',
            'table_number' => 'nullable|integer|required_if:order_type,dine_in|min:1|max:50',
            'payment_method_id' => 'required|integer|exists:payment_methods,id',
            'notes' => 'nullable|string|max:500',
            'scheduled_for' => 'nullable|date|after:now',
            'promo_code' => 'nullable|string|exists:promos,code',        ];
    }

    public function messages(): array
    {
        return [
            'order_type.required' => 'Tipe pesanan harus dipilih',
            'order_type.in' => 'Tipe pesanan tidak valid',
            'table_number.required_if' => 'Nomor meja diperlukan untuk dine-in',
            'table_number.min' => 'Nomor meja minimal 1',
            'table_number.max' => 'Nomor meja maksimal 50',
            'payment_method_id.required' => 'Metode pembayaran harus dipilih',
            'payment_method_id.exists' => 'Metode pembayaran tidak valid',
            'scheduled_for.after' => 'Waktu penjadwalan harus setelah waktu sekarang',
            'promo_code.exists' => 'Kode promo tidak valid',
        ];    }
}