<?php

namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class MenuFilterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'search' => ['nullable', 'string', 'max:100'],
            'category_id' => ['nullable', 'integer', 'exists:categories,id'],
            'special' => ['nullable', 'boolean'],
            'best_seller' => ['nullable', 'boolean'],
            'sort_by' => ['nullable', 'in:price_asc,price_desc,name,latest'],
            'per_page' => ['nullable', 'integer', 'min:1', 'max:50'],
            'min_price' => ['nullable', 'numeric', 'min:0'],
            'max_price' => ['nullable', 'numeric', 'min:0'],
        ];
    }

    public function messages(): array
    {
        return [
            'category_id.exists' => 'Kategori tidak ditemukan',
            'sort_by.in' => 'Opsi pengurutan tidak valid',
            'per_page.min' => 'Jumlah item per halaman minimal adalah 1',
            'per_page.max' => 'Jumlah item per halaman maksimal adalah 50',
            'min_price.min' => 'Harga minimum tidak boleh kurang dari 0',
            'max_price.min' => 'Harga maksimum tidak boleh kurang dari 0',
            'per_page.integer' => 'Jumlah item per halaman harus berupa angka',
        ];
    }
}