<?php
namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class CheckoutRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'order_type' => 'required|in:dine_in,takeaway,delivery',
            'table_number' => 'nullable|integer|required_if:order_type,dine_in',
            'payment_method_id' => 'required|integer|exists:payment_methods,id',
            'notes' => 'nullable|string|max:500',
            'scheduled_for' => 'nullable|date|after:now',
            'promo_code' => 'nullable|string|exists:promos,code',
        ];
    }

    public function messages(): array
    {
        return [
            'order_type.required' => 'Tipe pemesanan harus dipilih',
            'order_type.in' => 'Tipe pemesanan tidak valid',
            'table_number.required_if' => 'Nomor meja diperlukan untuk dine-in',
            'payment_method_id.required' => 'Metode pembayaran harus dipilih',
            'payment_method_id.exists' => 'Metode pembayaran tidak valid',
            'scheduled_for.after' => 'Waktu penjadwalan harus setelah waktu sekarang',
            'promo_code.exists' => 'Kode promo tidak valid',
        ];
    }
}