<?php
// app/Http/Requests/Api/Customer/CartUpdateRequest.php
namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class CartUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'quantity' => 'required|integer|min:1|max:20',
            'notes' => 'nullable|string|max:500',
        ];
    }
}