<?php
namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class CartStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'menu_id' => 'required|integer|exists:menus,id',
            'quantity' => 'required|integer|min:1|max:20',
            'notes' => 'nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'menu_id.required' => 'Menu harus dipilih',
            'menu_id.exists' => 'Menu tidak ditemukan',
            'quantity.min' => 'Minimal jumlah adalah 1',
            'quantity.max' => 'Maksimal jumlah adalah 20',
        ];
    }
}