<?php

namespace App\Http\Requests\Api\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProfileRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $userId = $this->user()->id;
        return [
            'name' => ['sometimes', 'string', 'max:255'],
            'email' => [
                'sometimes', 
                'email', 
                'max:255',
                Rule::unique('users')->ignore($userId)
            ],
            'phone' => [
                'sometimes', 
                'string', 
                'max:20',
                Rule::unique('users')->ignore($userId)
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'email.unique' => 'Email sudah terdaftar',
            'phone.unique' => 'Nomor telepon sudah terdaftar',
        ];
    }
}