<?php
// app/Http/Requests/Api/Admin/PromoRequest.php
namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PromoRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $id = $this->route('id');
        
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'type' => 'required|in:percentage,fixed,bogo',
            'discount_value' => 'required|numeric|min:0',
            'code' => [
                'nullable',
                'string',
                'max:50',
                Rule::unique('promos')->ignore($id)
            ],
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date',
            'is_active' => 'boolean',
        ];
    }
}