<?php
// app/Http/Requests/Api/Admin/PaymentMethodRequest.php
namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PaymentMethodRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $id = $this->route('id');
        
        return [
            'name' => [
                'required',
                'string',
                'max:100',
                Rule::unique('payment_methods')->ignore($id)
            ],
            'code' => 'required|in:cash,bank_transfer,ewallet,qris,credit_card',
            'is_active' => 'boolean',
        ];
    }
}