<?php
// app/Http/Requests/Api/Admin/JobPostingRequest.php
namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class JobPostingRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'title' => 'required|string|max:255',
            'department' => 'required|string|max:100',
            'location' => 'required|string|max:100',
            'description' => 'required|string',
            'requirements' => 'required|string',
            'employment_type' => 'required|in:full_time,part_time,contract,internship',
            'application_deadline' => 'required|date|after:today',
            'is_active' => 'boolean',
        ];
    }
}