<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckRoleWeb
{
    public function handle(Request $request, Closure $next, ...$roles)
    {
        // Cek auth dengan Laravel Auth
        if (!Auth::check()) {
            // Fallback: cek session manual
            if (!Session::has('is_logged_in') || !Session::has('user_role')) {
                return redirect()->route('login')->with('error', 'Please login to access this page');
            }
        }
        
        // Ambil role dari Auth atau Session
        if (Auth::check()) {
            $userRole = Auth::user()->role;
        } else {
            $userRole = Session::get('user_role');
        }
        
        // Cek role
        if (!in_array($userRole, $roles)) {
            // Redirect berdasarkan role user
            return match($userRole) {
                'admin' => redirect()->route('admin.dashboard'),
                'employee' => redirect()->route('employee.dashboard'),
                'customer' => redirect()->route('customer.dashboard'),
                default => redirect()->route('home'),
            };
        }

        return $next($request);
    }
}