<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckEmployee
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'Access denied. Employee or Admin role required.'
            ], 401);
        }

        if ($user->role !== 'employee' && $user->role !== 'admin') {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Employee or admin access required.'
            ], 403);
        }
        return $next($request);
    }
}
