<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckCustomer
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthenticated. Please login.'
            ], 401);
        }
        
        if (!$user || $user->role !== 'customer') {
            return response()->json([
                'success' => false,
                'message' => 'Access denied. Customer role required.'
            ], 403);
        }

        return $next($request);
    }
}
