<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AuthenticateWeb
{
    public function handle(Request $request, Closure $next)
    {
        // Cek menggunakan Laravel Auth
        if (Auth::check()) {
            return $next($request);
        }
        
        // Fallback: cek session manual (untuk kompatibilitas)
        if (Session::has('is_logged_in') && Session::has('user')) {
            return $next($request);
        }

        return redirect()->route('login')->withErrors([
            'message' => 'Please login to access this page'
        ]);
    }
}