<?php
// app/Http\Controllers/Web\Customer\CartController.php

namespace App\Http\Controllers\Web\Customer;

use App\Http\Controllers\Web\Api\BaseApiController;
use Illuminate\Http\Request;

class CartController extends BaseApiController
{
    public function index()
    {
        $response = $this->apiRequest('get', 'customer/cart');
        
        return $this->handleResponse($response, 'customer.cart.index', [
            'title' => 'My Cart'
        ]);
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'menu_id' => 'required|integer',
            'quantity' => 'required|integer|min:1',
            'notes' => 'nullable|string|max:500',
        ]);
        
        $response = $this->apiRequest('post', 'customer/cart', $request->all());
        
        return $this->handleRedirectResponse($response, 
            'customer.cart.index', 
            null, 
            'Item added to cart'
        );
    }
    
    public function update(Request $request, $menu_id)
    {
        $request->validate([
            'quantity' => 'required|integer|min:1',
            'notes' => 'nullable|string|max:500',
        ]);
        
        $response = $this->apiRequest('put', "customer/cart/{$menu_id}", $request->all());
        
        return $this->handleRedirectResponse($response, 
            'customer.cart.index', 
            null, 
            'Cart updated'
        );
    }
    
    public function destroy($menu_id)
    {
        $response = $this->apiRequest('delete', "customer/cart/{$menu_id}");
        
        return $this->handleRedirectResponse($response, 
            'customer.cart.index', 
            null, 
            'Item removed from cart'
        );
    }
    
    public function clear()
    {
        $response = $this->apiRequest('delete', 'customer/cart');
        
        return $this->handleRedirectResponse($response, 
            'customer.cart.index', 
            null, 
            'Cart cleared'
        );
    }
    
    public function checkoutSummary()
    {
        $response = $this->apiRequest('get', 'customer/cart/check-checkout');
        
        if (request()->ajax()) {
            return response()->json($response['data'] ?? []);
        }
        
        return $this->handleResponse($response, 'customer.cart.checkout', [
            'title' => 'Checkout Summary'
        ]);
    }
}