<?php
// app/Http\Controllers/Web/Admin/DashboardController.php

namespace App\Http\Controllers\Web\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Payment;
use App\Models\User;
use App\Models\Menu;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Get today's date range
        $today = Carbon::today();
        $startOfDay = $today->copy()->startOfDay();
        $endOfDay = $today->copy()->endOfDay();
        
        // Dashboard Statistics
        $dashboardData = [
            'total_orders' => Order::count(),
            'total_revenue' => Payment::where('status', 'confirmed')->sum('amount'),
            'total_customers' => User::where('role', 'customer')->count(),
            'total_menus' => Menu::count(),
            'today_orders' => Order::whereBetween('created_at', [$startOfDay, $endOfDay])->count(),
            'today_revenue' => Payment::where('status', 'confirmed')
                ->whereBetween('created_at', [$startOfDay, $endOfDay])
                ->sum('amount'),
            'pending_orders' => Order::where('status', 'pending')->count(),
            'processing_orders' => Order::where('status', 'processing')->count(),
        ];
        
        // Recent Orders
        $recentOrders = Order::with(['customer', 'orderItems.menu'])
            ->latest()
            ->limit(5)
            ->get();
        
        // Sales Data for Chart (last 7 days)
        $salesData = Order::where('status', 'completed')
            ->whereBetween('created_at', [Carbon::now()->subDays(7), Carbon::now()])
            ->select(
                DB::raw('DATE(created_at) as date'),
                DB::raw('COUNT(*) as total_orders'),
                DB::raw('SUM(final_amount) as total_sales')
            )
            ->groupBy('date')
            ->orderBy('date')
            ->get();
        
        $viewData = [
            'title' => 'Admin Dashboard',
            'dashboardData' => $dashboardData,
            'recentOrders' => $recentOrders,
            'salesData' => $salesData,
        ];
        
        return view('admin.dashboard', $viewData);
    }
    
    public function getDashboardData(Request $request)
    {
            // Get today's date range
    $today = Carbon::today();
    $startOfDay = $today->copy()->startOfDay();
    $endOfDay = $today->copy()->endOfDay();
    
    // Dashboard Statistics (SESUAI dengan yang di dashboard.blade.php)
    $data = [
        'totalOrders' => Order::count(),
        'totalRevenue' => Payment::where('status', 'confirmed')->sum('amount'),
        'totalCustomers' => User::where('role', 'customer')->count(),
        'pendingOrders' => Order::where('status', 'pending')->count(),
        'activePromos' => \App\Models\Promo::where('is_active', true)->count() ?? 0,
        'menuItems' => Menu::count(),
        'todayOrders' => Order::whereBetween('created_at', [$startOfDay, $endOfDay])->count(),
        'todayRevenue' => Payment::where('status', 'confirmed')
            ->whereBetween('created_at', [$startOfDay, $endOfDay])
            ->sum('amount'),
        'processingOrders' => Order::where('status', 'processing')->count(),
    ];

        $period = $request->period ?? 'today';
        
        $startDate = match($period) {
            'today' => Carbon::today(),
            'week' => Carbon::now()->subWeek(),
            'month' => Carbon::now()->subMonth(),
            'year' => Carbon::now()->subYear(),
            default => Carbon::today()
        };
        
        $salesData = Order::where('status', 'completed')
            ->whereBetween('created_at', [$startDate, Carbon::now()])
            ->select(
                DB::raw('DATE(created_at) as date'),
                DB::raw('COUNT(*) as total_orders'),
                DB::raw('SUM(final_amount) as total_sales')
            )
            ->groupBy('date')
            ->orderBy('date')
            ->get();
        
        return response()->json([
            'success' => true,
'stats' => $data,
        ]);
    }
}