<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

abstract class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;
    
    /**
     * Get layout name based on user role
     * Used by all controllers that extend this base controller
     */
    protected function getLayout()
    {
        /** @var bool $isAuthenticated */
    if (!$this->check()) {
        return 'layouts.app';
    }
     /** @var \App\Models\User $user */
    $role = $this->user()->role;
    
    return match($role) {
        'admin' => 'layouts.admin',
        'employee' => 'layouts.employee',  // ← PAKAI LAYOUT EMPLOYEE BARU
        'customer' => 'layouts.app',
        default => 'layouts.app'
    };    }
    
    /**
     * Share common data to views
     */
    protected function shareViewData()
    {
        // Share layout name to all views
        view()->share('layout', $this->getLayout());
        
        // Share user data if logged in
        /** @var bool $isAuthenticated */
        if ($this->check()) {
             /** @var \App\Models\User $user */
            view()->share('currentUser', $this->user());
            view()->share('userRole', $this->user()->role);
        }
    }
}