<?php

namespace App\Http\Controllers\Api\Employee;

use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;
use Illuminate\Http\JsonResponse;

class DashboardController extends Controller
{
    use ApiResponse;

    public function index(): JsonResponse
    {
        return $this->successResponse([
            'message' => 'Welcome to Employee Dashboard',
            'features' => [
                'Manage orders',
                'Update order status',
                'Confirm payments',
                'Validate payment proofs',
                'Print receipts',
                'View today\'s orders'
            ]
        ], 'Employee dashboard loaded successfully');
    }
}