<?php

namespace App\Http\Controllers\Api\Customer;

use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;
use Illuminate\Http\JsonResponse;

class DashboardController extends Controller
{
    use ApiResponse;

    public function index(): JsonResponse
    {
        return $this->successResponse([
            'message' => 'Welcome to Customer Dashboard',
            'features' => [
                'View menu & promotions',
                'Add to cart',
                'Place orders',
                'Track order status',
                'View transaction history',
                'Rate products',
                'Apply for careers'
            ]
        ], 'Customer dashboard loaded successfully');
    }
}