<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;
use Illuminate\Http\JsonResponse;

class DashboardController extends Controller
{
    use ApiResponse;

    public function index(): JsonResponse
    {
        return $this->successResponse([
            'message' => 'Welcome to Admin Dashboard',
            'features' => [
                'CRUD Menu Items',
                'CRUD Promotions',
                'CRUD Payment Methods',
                'Manage Careers/Job Postings',
                'System Settings',
                'View Sales Reports',
                'View Financial Reports',
                'View Employee Performance',
                'Manage Users'
            ]
        ], 'Admin dashboard loaded successfully');
    }
}